# coding: utf-8
# python 2 only

import linuxcnc
import threading
import time
import os
import types
import ConfigParser
import smtplib
import gtk
import glib
from email.mime.text import MIMEText
from ui_hooks import plugin
import singletons
import constants

class UserPlugin(plugin):
    def __init__(self):
        plugin.__init__(self, 'Job Completion Trigger')
        self.ui = None
        self.config_file = os.path.expanduser('~/gcode/python/notifier_config.ini')
        t = threading.Thread(target=self.setup_hook)
        t.daemon = True
        t.start()
        glib.timeout_add(3000, self.setup_key_handler)
        self.ShowMsg("Job completion notifier loaded (Ctrl+H to toggle)", constants.ALARM_LEVEL_QUIET)

    def _load_config(self):
        if not os.path.exists(self.config_file):
            raise IOError("Config file not found")
        config = ConfigParser.ConfigParser()
        config.read(self.config_file)
        return config

    def is_enabled(self):
        try:
            config = self._load_config()
            return config.getint('settings', 'enabled') == 1
        except Exception:
            return False

    def toggle_enabled(self):
        try:
            config = self._load_config()
            enabled = config.getint('settings', 'enabled')
            new_value = 0 if enabled else 1
            config.set('settings', 'enabled', str(new_value))
            with open(self.config_file, 'w') as f:
                config.write(f)
            state = "ENABLED" if new_value else "DISABLED"
            self.ShowMsg("Job completion email " + state, constants.ALARM_LEVEL_MEDIUM)
        except Exception as e:
            self.ShowMsg("Toggle error: " + str(e), constants.ALARM_LEVEL_LOW)

    def send_operation_complete_email(self):
        try:
            config = self._load_config()
            sender = config.get('email', 'sender')
            recipient = config.get('email', 'recipient')
            subject = config.get('email', 'subject')
            body = config.get('email', 'body').replace('\\n', '\n')
            smtp_server = config.get('email', 'smtp_server')
            smtp_port = config.getint('email', 'smtp_port')
            smtp_username = config.get('email', 'smtp_username')
            smtp_password = config.get('email', 'smtp_password')
            msg = MIMEText(body)
            msg['From'] = sender
            msg['To'] = recipient
            msg['Subject'] = subject
            smtp = smtplib.SMTP_SSL(smtp_server, smtp_port)
            smtp.login(smtp_username, smtp_password)
            smtp.sendmail(sender, [recipient], msg.as_string())
            smtp.quit()
            self.ShowMsg("Operation complete email sent", constants.ALARM_LEVEL_MEDIUM)
        except Exception as e:
            self.ShowMsg("Email send failed: " + str(e), constants.ALARM_LEVEL_LOW)

    def setup_key_handler(self):
        main_ui = getattr(singletons, 'g_Machine', None)
        if main_ui and hasattr(main_ui, 'window'):
            main_ui.window.add_events(gtk.gdk.KEY_PRESS_MASK)
            main_ui.window.connect("key-press-event", self.on_global_key_press)
            self.ShowMsg("Ctrl+H bound to toggle notifier",   constants.ALARM_LEVEL_QUIET)
        return False

    def on_global_key_press(self, widget, event):
        if (event.state & gtk.gdk.CONTROL_MASK and event.keyval == gtk.keysyms.h):
            self.toggle_enabled()
            return True
        return False

    def setup_hook(self):
        while True:
            try:
                if hasattr(singletons, 'g_Machine') and singletons.g_Machine:
                    self.ui = singletons.g_Machine
                    original = self.ui.handle_interp_task_status_change
                    def make_wrapper(plugin_self, orig_handler):
                        def wrapped(self):
                            prev_interp = self.prev_lcnc_interp_state
                            orig_handler()
                            if not plugin_self.is_enabled():
                                return
                            if (self.status.interp_state == linuxcnc.INTERP_IDLE and
                                prev_interp not in (
                                    linuxcnc.INTERP_IDLE,
                                    linuxcnc.INTERP_SEEKING
                                ) and
                                self.status.task_mode == linuxcnc.MODE_AUTO and
                                self.status.task_state == linuxcnc.STATE_ON):
                                plugin_self.ShowMsg(
                                    "Program end detected", constants.ALARM_LEVEL_MEDIUM
                                )
                                plugin_self.send_operation_complete_email()

                        return wrapped
                    wrapper = make_wrapper(self, original)
                    self.ui.handle_interp_task_status_change = types.MethodType(wrapper, self.ui)
                    self.ShowMsg("Job completion hook installed", constants.ALARM_LEVEL_QUIET)
                    return
            except Exception as e:
                self.ShowMsg("Hook setup error: " + str(e), constants.ALARM_LEVEL_LOW)
            time.sleep(0.5)